/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.api.coords;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.runelite.api.CollisionData;
import net.runelite.api.Point;
import net.runelite.api.Tile;
import net.runelite.api.WorldView;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;

public class WorldArea {
    private int x;
    private int y;
    private int width;
    private int height;
    private int plane;

    public WorldArea(int x2, int y2, int width, int height, int plane) {
        this.x = x2;
        this.y = y2;
        this.width = width;
        this.height = height;
        this.plane = plane;
    }

    public WorldArea(WorldPoint location, int width, int height) {
        this.x = location.getX();
        this.y = location.getY();
        this.plane = location.getPlane();
        this.width = width;
        this.height = height;
    }

    private Point getAxisDistances(WorldArea other) {
        Point p1 = this.getComparisonPoint(other);
        Point p2 = other.getComparisonPoint(this);
        return new Point(Math.abs(p1.getX() - p2.getX()), Math.abs(p1.getY() - p2.getY()));
    }

    public int distanceTo(WorldArea other) {
        if (this.getPlane() != other.getPlane()) {
            return Integer.MAX_VALUE;
        }
        return this.distanceTo2D(other);
    }

    public int distanceTo(WorldPoint other) {
        return this.distanceTo(other.toWorldArea());
    }

    public int distanceTo2D(WorldArea other) {
        Point distances = this.getAxisDistances(other);
        return Math.max(distances.getX(), distances.getY());
    }

    public int distanceTo2D(WorldPoint other) {
        return this.distanceTo2D(other.toWorldArea());
    }

    public boolean contains(WorldPoint worldPoint) {
        return this.distanceTo(worldPoint) == 0;
    }

    public boolean contains2D(WorldPoint worldPoint) {
        return this.distanceTo2D(worldPoint) == 0;
    }

    public boolean isInMeleeDistance(WorldArea other) {
        if (other == null || this.getPlane() != other.getPlane()) {
            return false;
        }
        Point distances = this.getAxisDistances(other);
        return distances.getX() + distances.getY() == 1;
    }

    public boolean isInMeleeDistance(WorldPoint other) {
        return this.isInMeleeDistance(other.toWorldArea());
    }

    public boolean intersectsWith(WorldArea other) {
        if (this.getPlane() != other.getPlane()) {
            return false;
        }
        Point distances = this.getAxisDistances(other);
        return distances.getX() + distances.getY() == 0;
    }

    public boolean canTravelInDirection(WorldView wv, int dx2, int dy2) {
        return this.canTravelInDirection(wv, dx2, dy2, x2 -> true);
    }

    public boolean canTravelInDirection(WorldView wv, int dx2, int dy2, Predicate<? super WorldPoint> extraCondition) {
        CollisionData[] collisionData;
        dx2 = Integer.signum(dx2);
        dy2 = Integer.signum(dy2);
        if (dx2 == 0 && dy2 == 0) {
            return true;
        }
        LocalPoint lp = LocalPoint.fromWorld(wv, this.x, this.y);
        int startX = lp.getSceneX() + dx2;
        int startY = lp.getSceneY() + dy2;
        int checkX = startX + (dx2 > 0 ? this.width - 1 : 0);
        int checkY = startY + (dy2 > 0 ? this.height - 1 : 0);
        int endX = startX + this.width - 1;
        int endY = startY + this.height - 1;
        int xFlags = 2359552;
        int yFlags = 2359552;
        int xyFlags = 2359552;
        int xWallFlagsSouth = 2359552;
        int xWallFlagsNorth = 2359552;
        int yWallFlagsWest = 2359552;
        int yWallFlagsEast = 2359552;
        if (dx2 < 0) {
            xFlags |= 8;
            xWallFlagsSouth |= 0x30;
            xWallFlagsNorth |= 6;
        }
        if (dx2 > 0) {
            xFlags |= 0x80;
            xWallFlagsSouth |= 0x60;
            xWallFlagsNorth |= 3;
        }
        if (dy2 < 0) {
            yFlags |= 2;
            yWallFlagsWest |= 0x81;
            yWallFlagsEast |= 0xC;
        }
        if (dy2 > 0) {
            yFlags |= 0x20;
            yWallFlagsWest |= 0xC0;
            yWallFlagsEast |= 0x18;
        }
        if (dx2 < 0 && dy2 < 0) {
            xyFlags |= 4;
        }
        if (dx2 < 0 && dy2 > 0) {
            xyFlags |= 0x10;
        }
        if (dx2 > 0 && dy2 < 0) {
            xyFlags |= 1;
        }
        if (dx2 > 0 && dy2 > 0) {
            xyFlags |= 0x40;
        }
        if ((collisionData = wv.getCollisionMaps()) == null) {
            return false;
        }
        int[][] collisionDataFlags = collisionData[this.plane].getFlags();
        if (dx2 != 0) {
            int y2;
            for (y2 = startY; y2 <= endY; ++y2) {
                if ((collisionDataFlags[checkX][y2] & xFlags) == 0 && extraCondition.test(WorldPoint.fromScene(wv, checkX, y2, this.plane))) continue;
                return false;
            }
            for (y2 = startY + 1; y2 <= endY; ++y2) {
                if ((collisionDataFlags[checkX][y2] & xWallFlagsSouth) == 0) continue;
                return false;
            }
            for (y2 = endY - 1; y2 >= startY; --y2) {
                if ((collisionDataFlags[checkX][y2] & xWallFlagsNorth) == 0) continue;
                return false;
            }
        }
        if (dy2 != 0) {
            int x2;
            for (x2 = startX; x2 <= endX; ++x2) {
                if ((collisionDataFlags[x2][checkY] & yFlags) == 0 && extraCondition.test(WorldPoint.fromScene(wv, x2, checkY, wv.getPlane()))) continue;
                return false;
            }
            for (x2 = startX + 1; x2 <= endX; ++x2) {
                if ((collisionDataFlags[x2][checkY] & yWallFlagsWest) == 0) continue;
                return false;
            }
            for (x2 = endX - 1; x2 >= startX; --x2) {
                if ((collisionDataFlags[x2][checkY] & yWallFlagsEast) == 0) continue;
                return false;
            }
        }
        if (dx2 != 0 && dy2 != 0) {
            if ((collisionDataFlags[checkX][checkY] & xyFlags) != 0 || !extraCondition.test(WorldPoint.fromScene(wv, checkX, checkY, wv.getPlane()))) {
                return false;
            }
            if (this.width == 1 && (collisionDataFlags[checkX][checkY - dy2] & xFlags) != 0 && extraCondition.test(WorldPoint.fromScene(wv, checkX, startY, wv.getPlane()))) {
                return false;
            }
            if (this.height == 1 && (collisionDataFlags[checkX - dx2][checkY] & yFlags) != 0 && extraCondition.test(WorldPoint.fromScene(wv, startX, checkY, wv.getPlane()))) {
                return false;
            }
        }
        return true;
    }

    private Point getComparisonPoint(WorldArea other) {
        int x2 = other.x <= this.x ? this.x : (other.x >= this.x + this.width - 1 ? this.x + this.width - 1 : other.x);
        int y2 = other.y <= this.y ? this.y : (other.y >= this.y + this.height - 1 ? this.y + this.height - 1 : other.y);
        return new Point(x2, y2);
    }

    public boolean hasLineOfSightTo(WorldView wv, WorldArea other) {
        if (this.plane != other.getPlane()) {
            return false;
        }
        List<WorldPoint> fromEdges = other.getVisibleCandidates(this);
        List<WorldPoint> toEdges = this.getVisibleCandidates(other);
        Tile[][][] tiles = wv.getScene().getTiles();
        for (WorldPoint fromPoint : fromEdges) {
            for (WorldPoint toPoint : toEdges) {
                LocalPoint fromLp = LocalPoint.fromWorld(wv, fromPoint);
                LocalPoint toLp = LocalPoint.fromWorld(wv, toPoint);
                if (fromLp == null || toLp == null) continue;
                Tile sourceTile = tiles[this.plane][fromLp.getSceneX()][fromLp.getSceneY()];
                Tile targetTile = tiles[other.getPlane()][toLp.getSceneX()][toLp.getSceneY()];
                if (sourceTile == null || targetTile == null || !WorldArea.hasLineOfSightTo(wv, sourceTile, targetTile)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasLineOfSightTo(WorldView wv, Tile from, Tile to) {
        if (from.getPlane() != to.getPlane()) {
            return false;
        }
        CollisionData[] collisionData = wv.getCollisionMaps();
        if (collisionData == null) {
            return false;
        }
        int z2 = from.getPlane();
        int[][] collisionDataFlags = collisionData[z2].getFlags();
        Point p1 = from.getSceneLocation();
        Point p2 = to.getSceneLocation();
        if (p1.getX() == p2.getX() && p1.getY() == p2.getY()) {
            return true;
        }
        int dx2 = p2.getX() - p1.getX();
        int dy2 = p2.getY() - p1.getY();
        int dxAbs = Math.abs(dx2);
        int dyAbs = Math.abs(dy2);
        int xFlags = 131072;
        int yFlags = 131072;
        xFlags = dx2 < 0 ? (xFlags |= 0x1000) : (xFlags |= 0x10000);
        yFlags = dy2 < 0 ? (yFlags |= 0x400) : (yFlags |= 0x4000);
        if (dxAbs > dyAbs) {
            int direction;
            int x2 = p1.getX();
            int yBig = p1.getY() << 16;
            int slope = (dy2 << 16) / dxAbs;
            yBig += 32768;
            if (dy2 < 0) {
                --yBig;
            }
            int n2 = direction = dx2 < 0 ? -1 : 1;
            while (x2 != p2.getX()) {
                int y2 = yBig >>> 16;
                if ((collisionDataFlags[x2 += direction][y2] & xFlags) != 0) {
                    return false;
                }
                int nextY = (yBig += slope) >>> 16;
                if (nextY == y2 || (collisionDataFlags[x2][nextY] & yFlags) == 0) continue;
                return false;
            }
        } else {
            int direction;
            int y3 = p1.getY();
            int xBig = p1.getX() << 16;
            int slope = (dx2 << 16) / dyAbs;
            xBig += 32768;
            if (dx2 < 0) {
                --xBig;
            }
            int n3 = direction = dy2 < 0 ? -1 : 1;
            while (y3 != p2.getY()) {
                int x3 = xBig >>> 16;
                if ((collisionDataFlags[x3][y3 += direction] & yFlags) != 0) {
                    return false;
                }
                int nextX = (xBig += slope) >>> 16;
                if (nextX == x3 || (collisionDataFlags[nextX][y3] & xFlags) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasLineOfSightTo(WorldView wv, WorldPoint other) {
        return this.hasLineOfSightTo(wv, other.toWorldArea());
    }

    private List<WorldPoint> getVisibleCandidates(WorldArea other) {
        Point compPoint = this.getComparisonPoint(other);
        Comparator<WorldPoint> byDistance = Comparator.comparingInt(p2 -> p2.distanceTo(new WorldPoint(compPoint.getX(), compPoint.getY(), this.getPlane())));
        return other.toWorldPointList().stream().filter(p2 -> WorldArea.isEdgePoint(other, p2)).filter(p2 -> this.isVisibleCandidate(other, (WorldPoint)p2)).sorted(byDistance).collect(Collectors.toList());
    }

    private static boolean isEdgePoint(WorldArea wa, WorldPoint p2) {
        return p2.getX() == wa.getX() || p2.getX() == wa.getX() + wa.getWidth() - 1 || p2.getY() == wa.getY() || p2.getY() == wa.getY() + wa.getHeight() - 1;
    }

    private boolean isVisibleCandidate(WorldArea other, WorldPoint p2) {
        if (this.intersectsWith(other)) {
            return false;
        }
        if (this.getX() + this.getWidth() - 1 > other.getX() + other.getWidth() - 1) {
            if (this.getY() < other.getY()) {
                return p2.getX() == other.getX() + other.getWidth() - 1 || p2.getY() == other.getY();
            }
            if (this.getY() + this.getHeight() - 1 > other.getY() + other.getHeight() - 1) {
                return p2.getX() == other.getX() + other.getWidth() - 1 || p2.getY() == other.getY() + other.getHeight() - 1;
            }
            return p2.getX() == other.getX() + other.getWidth() - 1;
        }
        if (this.getX() < other.getX()) {
            if (this.getY() < other.getY()) {
                return p2.getX() == other.getX() || p2.getY() == other.getY();
            }
            if (this.getY() + this.getHeight() - 1 > other.getY() + other.getHeight() - 1) {
                return p2.getX() == other.getX() || p2.getY() == other.getY() + other.getHeight() - 1;
            }
            return p2.getX() == other.getX();
        }
        if (this.getY() > other.getY() + other.getHeight() - 1) {
            return p2.getY() == other.getY() + other.getHeight() - 1;
        }
        if (this.getY() < other.getY()) {
            return p2.getY() == other.getY();
        }
        return false;
    }

    public WorldPoint toWorldPoint() {
        return new WorldPoint(this.x, this.y, this.plane);
    }

    public List<WorldPoint> toWorldPointList() {
        ArrayList<WorldPoint> list = new ArrayList<WorldPoint>(this.width * this.height);
        for (int x2 = 0; x2 < this.width; ++x2) {
            for (int y2 = 0; y2 < this.height; ++y2) {
                list.add(new WorldPoint(this.getX() + x2, this.getY() + y2, this.getPlane()));
            }
        }
        return list;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPlane() {
        return this.plane;
    }
}

